/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.client.screen.skill;

import dev.toma.gunsrpg.api.common.data.IPerkProvider;
import dev.toma.gunsrpg.api.common.data.IPlayerData;
import dev.toma.gunsrpg.api.common.perk.IPerkStat;
import dev.toma.gunsrpg.client.screen.skill.IViewContext;
import dev.toma.gunsrpg.client.screen.skill.IViewManager;
import dev.toma.gunsrpg.client.screen.skill.SkillsView;
import dev.toma.gunsrpg.client.screen.skill.View;
import dev.toma.gunsrpg.client.screen.widgets.FooterWidget;
import dev.toma.gunsrpg.client.screen.widgets.HeaderWidget;
import dev.toma.gunsrpg.client.screen.widgets.PannableWidget;
import dev.toma.gunsrpg.client.screen.widgets.PerkWidget;
import dev.toma.gunsrpg.client.screen.widgets.ViewSwitchWidget;
import dev.toma.gunsrpg.common.init.ModItems;
import dev.toma.gunsrpg.common.item.perk.CrystalAttribute;
import dev.toma.gunsrpg.common.perk.Perk;
import dev.toma.gunsrpg.common.perk.PerkRegistry;
import dev.toma.gunsrpg.common.perk.PerkType;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class PerkView
extends View {
    private PannableWidget pannableWidget;
    private FooterWidget footerWidget;
    private ViewSwitchWidget viewSwitchWidget;

    public PerkView(int windowWidth, int windowHeight, IViewManager manager) {
        super(windowWidth, windowHeight, manager);
    }

    @Override
    protected void init() {
        this.clear();
        this.viewSwitchWidget = this.addWidget(new ViewSwitchWidget(this.field_230690_l_ + this.field_230688_j_ - 42, this.field_230689_k_ - 62, 32, 32, new ItemStack((IItemProvider)ModItems.SKILLPOINT_BOOK)));
        this.viewSwitchWidget.setClickEvent(this::openSkillView);
        this.viewSwitchWidget.setColorSchema(4825599, 4839679);
        this.pannableWidget = this.addWidget(new PannableWidget(this.field_230690_l_, this.field_230691_m_ + 20, this.field_230688_j_, this.field_230689_k_ - 40));
        this.pannableWidget.fill((handler, px, py) -> {
            Set<Perk> allPerks = PerkRegistry.getRegistry().getPerks();
            IPerkProvider provider = this.manager.getContext().getData().getPerkProvider();
            ArrayList<Perk> ownedPerks = new ArrayList<Perk>(provider.getActivePerks());
            Comparator<Perk> valueComparator = Comparator.comparing(perk -> provider.getPerkStat((Perk)perk).getAttribute(), Comparator.comparing(attribute -> Float.valueOf(-Math.abs(attribute.getValue()))));
            Comparator<Perk> typeComparator = Comparator.comparing(perk -> provider.getPerkStat((Perk)perk).getAttribute(), Comparator.comparing(attr -> attr.getType().ordinal()));
            ownedPerks.sort(typeComparator.thenComparing(valueComparator));
            int index = 0;
            int yOffset = 0;
            int maxWidth = (this.field_230688_j_ - 85) / 85;
            for (Perk perk2 : ownedPerks) {
                allPerks.remove(perk2);
                IPerkStat stat = provider.getPerkStat(perk2);
                CrystalAttribute crystalAttribute = stat.getAttribute();
                PerkType type = crystalAttribute.getType();
                float value = crystalAttribute.getValue();
                PerkWidget.State state = value == 0.0f ? PerkWidget.State.NULLIFIED : (type == PerkType.BUFF ? PerkWidget.State.BUFF : PerkWidget.State.DEBUFF);
                int x = 30 + px + index % maxWidth * 85;
                int y = 5 + py + (yOffset + index / maxWidth) * 35;
                handler.add(new PerkWidget(x, y, 80, 20, this.font, perk2, value, state));
                ++index;
            }
            yOffset = 1 + (index - 1) / maxWidth;
            if (ownedPerks.isEmpty()) {
                --yOffset;
            }
            index = 0;
            for (Perk perk2 : allPerks) {
                int x = 30 + px + index % maxWidth * 85;
                int y = 5 + py + (yOffset + index / maxWidth) * 35;
                handler.add(new PerkWidget(x, y, 80, 20, this.font, perk2, 0.0f, PerkWidget.State.NONE));
                ++index;
            }
        });
        ITextComponent userName = this.client.field_71439_g.func_200200_C_();
        TranslationTextComponent headerTitle = new TranslationTextComponent("view.perk.header", new Object[]{userName.getString()});
        this.addWidget(new HeaderWidget(this.field_230690_l_, this.field_230691_m_, this.field_230688_j_, 20, (ITextComponent)headerTitle, this.font));
        IViewContext viewContext = this.manager.getContext();
        IPlayerData data = viewContext.getData();
        IPerkProvider perkProvider = data.getPerkProvider();
        this.footerWidget = this.addWidget(new FooterWidget(this.field_230690_l_, this.field_230691_m_ + this.field_230689_k_ - 20, this.field_230688_j_, 20, this.client.field_71466_p, perkProvider));
        this.footerWidget.setPointColor(65535);
    }

    private void openSkillView() {
        this.manager.setView(new SkillsView(this.field_230688_j_, this.field_230689_k_, this.manager));
    }
}

